create or replace view tbicds.vw_intake as
select (select t1.module
         from (select t1.module, t4.mid, t4.tid, t4.qid, t4.rid
                from intake_module t1,
                     (select t2.mid, min(t2.tid) tid from intake_topic t2 group by t2.mid) t2,
                     (select t3.mid, t3.tid, min(t3.qid) qid from intake_question t3 group by t3.mid, t3.tid) t3,
                     (select t4.mid, t4.tid, t4.qid, min(t4.rid) rid from intake_response t4 group by  t4.mid, t4.tid, t4.qid) t4
                where t1.mid = t2.mid
                  and t2.mid = t3.mid
                  and t2.tid = t3.tid
                  and t3.mid = t4.mid
                  and t3.tid = t4.tid
                  and t3.qid = t4.qid
                ) t1
       where t1.mid = t4.mid
        and t1.tid = t4.tid
        and t1.qid = t4.qid
        and t1.rid = t4.rid
       ) as module,

       (select t1.topic
         from (select t1.topic, t4.mid, t4.tid, t4.qid, t4.rid
                from intake_topic t1,
                     (select t3.mid, t3.tid, min(t3.qid) qid from intake_question t3 group by t3.mid, t3.tid) t3,
                     (select t4.mid, t4.tid, t4.qid, min(t4.rid) rid from intake_response t4 group by  t4.mid, t4.tid, t4.qid) t4
                where t1.mid = t3.mid
                  and t1.tid = t3.tid
                  and t3.mid = t4.mid
                  and t3.tid = t4.tid
                  and t3.qid = t4.qid
                ) t1
       where t1.mid = t4.mid
        and t1.tid = t4.tid
        and t1.qid = t4.qid
        and t1.rid = t4.rid
       ) as topic,
       (select t1.question
         from (select t1.question, t4.mid, t4.tid, t4.qid, t4.rid
                from intake_question t1,
                     (select t4.mid, t4.tid, t4.qid, min(t4.rid) rid from intake_response t4 group by  t4.mid, t4.tid, t4.qid) t4
                where t1.mid = t4.mid
                  and t1.tid = t4.tid
                  and t1.qid = t4.qid
                ) t1
       where t1.mid = t4.mid
        and t1.tid = t4.tid
        and t1.qid = t4.qid
        and t1.rid = t4.rid
       ) as question,
       t4.response
 from intake_response t4
order by t4.mid, t4.tid, t4.qid, t4.rid
/

